/******************************************************************************
 *
 * Copyright (c) 2000-2003 PalmSource, Inc. All rights reserved.
 *
 * File: CmnKeyTypes.h
 *
 * Release: Palm OS 6.0
 *
 * Description:
 *	  Key constant definitions shared by DAL and Palm OS.
 *
 *****************************************************************************/

#ifndef _CMNKEYTYPES_H_
#define _CMNKEYTYPES_H_


#include <PalmTypes.h>
//#include <Chars.h>	// 5.0 had this, but I don't see why...



/********************************************************************
 * Definition of bit field returned from KeyCurrentState
 ********************************************************************/
#define	keyBitPower				0x00000001		// Power key
#define	keyBitPageUp			0x00000002		// Page-up
#define	keyBitPageDown			0x00000004		// Page-down
#define	keyBitHard1				0x00000008		// App #1
#define	keyBitHard2				0x00000010		// App #2
#define	keyBitHard3				0x00000020		// App #3
#define	keyBitHard4				0x00000040		// App #4
#define	keyBitCradle			0x00000080		// Button on cradle
#define	keyBitAntenna			0x00000100		// Antenna "key" <chg 3-31-98 RM>
#define	keyBitContrast			0x00000200		// Contrast key

#define keyBitThumbWheelUp		0x00001000		// Thumb wheel
#define keyBitThumbWheelDown	0x00002000
#define keyBitThumbWheelPush	0x00004000
#define keyBitThumbWheelBack	0x00008000

#define keyBitRockerUp			0x00010000		// 5-way rocker
#define keyBitRockerDown		0x00020000
#define keyBitRockerLeft		0x00040000
#define keyBitRockerRight		0x00080000
#define keyBitRockerCenter		0x00100000

#define	keyBitsAll				0xFFFFFFFF	// all keys

#define slowestKeyDelayRate	0xff
#define slowestKeyPeriodRate	0xff

// keyDownEvent modifers
#define shiftKeyMask       0x0001
#define capsLockMask       0x0002
#define numLockMask        0x0004
#define commandKeyMask     0x0008
#define optionKeyMask      0x0010
#define controlKeyMask     0x0020
#define autoRepeatKeyMask  0x0040      // True if generated due to auto-repeat
#define doubleTapKeyMask   0x0080      // True if this is a double-tap event
#define poweredOnKeyMask   0x0100      // True if this is a double-tap event
#define appEvtHookKeyMask  0x0200      // True if this is an app hook key
#define libEvtHookKeyMask  0x0400      // True if this is a library hook key
#define willGoUpKeyMask	   0x0800      // True if this a key down will send a key up
#define softwareKeyMask    0x1000      // True if generated by software (i.e., graffiti or status bar)

#endif //_CMNKEYTYPES_H_
